"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_CONFIG = void 0;
var _package = require("../package.json");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const DEFAULT_CONFIG = {
  searchguard: {
    enabled: true,
    sg_frontend_config_id: "default",
    frontend_base_url: null,
    allow_client_certificates: false,
    readonly_mode: {
      enabled: true,
      roles: []
    },
    xff: {
      enabled: true
    },
    cookie: {
      secure: false,
      password: 'searchguard_cookie_default_password',
      name: 'searchguard_authentication',
      ttl: null,
      isSameSite: 'Lax'
    },
    auth: {
      // @todo This is still being used in the FE, does it really work?
      type: 'default',
      anonymous_auth_enabled: false,
      unauthenticated_routes: ['/api/status', '/internal/security/me'],
      debug: false,
      jwt_param: {
        enabled: false,
        url_param: 'authorization'
      }
    },
    basicauth: {
      forbidden_usernames: [],
      allowed_usernames: null
    },
    multitenancy: {
      debug: false
    },
    configuration: {
      enabled: true,
      action_groups_page: {
        enabled: true
      },
      create_action_groups_page: {
        enabled: true
      },
      internal_users_page: {
        enabled: true
      },
      create_internal_users_page: {
        enabled: true
      },
      roles_page: {
        enabled: true
      },
      create_roles_page: {
        enabled: true
      },
      role_mappings_page: {
        enabled: true
      },
      create_role_mappings_page: {
        enabled: true
      },
      tenants_page: {
        enabled: true
      },
      create_tenants_page: {
        enabled: true
      },
      system_status_page: {
        enabled: true
      },
      license_page: {
        enabled: true
      },
      cache_page: {
        enabled: true
      }
    },
    accountinfo: {
      enabled: true
    },
    sgVersion: _package.version
  }
};
exports.DEFAULT_CONFIG = DEFAULT_CONFIG;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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